#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodTestType : BaseTest 
	{
		
		private DataTable _dtBloodTestType;
		private BOL.BloodTestType _tstBTT; 
		private int _bloodTestTypeId;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodTestType = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodTestType WHERE OrderableTestId IS NOT NULL AND Phase IS NOT NULL AND ReportableTestId IS NOT NULL",  true);

				this._bloodTestTypeId = (int)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.BloodTestTypeId];

				this.RefreshData = false;
			}

			this._tstBTT = new BOL.BloodTestType(this._bloodTestTypeId);
		}

		[Test]
		public void Ctor_Int_Pass()
		{
			BOL.BloodTestType tmpBTT = new BOL.BloodTestType(this._bloodTestTypeId);
			
			Assert.IsNotNull(tmpBTT);
			Assert.IsTrue(tmpBTT.BloodTestTypeId == this._bloodTestTypeId);
			Assert.IsTrue(tmpBTT.BloodTestName == this._dtBloodTestType.Rows[0][TABLES.BloodTestType.BloodTestName].ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Int_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.BloodTestType tmpBTT = new BOL.BloodTestType(this._dtBloodTestType.Rows[0]);

			Assert.IsTrue(tmpBTT.BloodTestTypeId == this._bloodTestTypeId);
			Assert.IsTrue(tmpBTT.BloodTestName == this._dtBloodTestType.Rows[0][TABLES.BloodTestType.BloodTestName].ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void GetBloodTestType_Pass()
		{
			BOL.BloodTestType tmpBTT = BOL.BloodTestType.GetBloodTestType(this._bloodTestTypeId);
			BOL.BloodTestType tmpBTT2 = new BOL.BloodTestType(this._bloodTestTypeId);

			Assert.IsTrue(tmpBTT.BloodTestName == tmpBTT2.BloodTestName);
			Assert.IsTrue(tmpBTT.BloodTestTypeId == tmpBTT2.BloodTestTypeId);
			Assert.IsTrue(tmpBTT.SortColumn == tmpBTT2.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodTestType_Fail()
		{
		}

		[Test]
		public void GetBloodTestTypes_Pass()
		{
			string testId = this._dtBloodTestType.Rows[0][TABLES.BloodTestType.OrderableTestId].ToString();

			DataTable dtTest = BOL.BloodTestType.GetBloodTestTypes(testId);
			Assert.IsTrue(dtTest.Rows.Count >= 1);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodTestTypes_Fail()
		{
		}

		[Test]
		public void BloodTestTypeId_Pass()
		{
			Assert.IsTrue(this._tstBTT.BloodTestTypeId == this._bloodTestTypeId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BloodTestTypeId_Fail()
		{
		}

		[Test]
		public void BloodTestName_Pass()
		{
			string tstValue = this._dtBloodTestType.Rows[0][TABLES.BloodTestType.BloodTestName].ToString();

			Assert.IsTrue(this._tstBTT.BloodTestName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BloodTestName_Fail()
		{
		}	

		[Test]
		public void OrderableTestId_Pass()
		{
			int tstValue = (int)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.OrderableTestId];

			Assert.IsTrue(this._tstBTT.OrderableTestId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OrderableTestId_Fail()
		{
		}

		[Test]
		public void SortColumn_Pass()
		{
			short tstValue = (short)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.SortColumn];
			
			Assert.IsTrue(this._tstBTT.SortColumn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			System.DateTime tstValue = (System.DateTime)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.LastUpdateDate];

			Assert.IsTrue(this._tstBTT.LastUpdateDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			string tstValue = this._dtBloodTestType.Rows[0][TABLES.BloodTestType.LastUpdateUser].ToString();

			Assert.IsTrue(this._tstBTT.LastUpdateUser == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateUser_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = (byte[])this._dtBloodTestType.Rows[0][TABLES.BloodTestType.RowVersion];

			Assert.IsTrue(this._tstBTT.RowVersion.Length == tstValue.Length);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void TestedWith_Pass()
		{
			string tstValue = this._dtBloodTestType.Rows[0][TABLES.BloodTestType.TestedWith].ToString();

			Assert.IsTrue(this._tstBTT.TestedWith == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestedWith_Fail()
		{
		}

		[Test]
		public void Phase_Pass()
		{
			string tstValue = this._dtBloodTestType.Rows[0][TABLES.BloodTestType.Phase].ToString();

			Assert.IsTrue(this._tstBTT.Phase == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Phase_Fail()
		{
		}

		[Test]
		public void ReportableTestId_Pass()
		{
			int tstValue = (int)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.ReportableTestId];

			Assert.IsTrue(this._tstBTT.ReportableTestId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ReportableTestId_Fail()
		{
		}

	}
}
#endif


